/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.simulation;

import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.StateMachine;
import DE.siemens.ad.pdraw.simulation.OfflineInterpreter;
import DE.siemens.ad.pdraw.simulation.SimulationControl;

public class StepSimulationAction
extends LogoAction {
    public StepSimulationAction() {
        this.putValue("Name", "stepSimulation");
        this.putValue("textKey", "simulationControl.stepSimulation");
        this.putValue("SmallIcon", Global.getIcon("Step.gif"));
    }

    public boolean doIt() {
        SimulationControl simulationControl = (SimulationControl)this.getOwner();
        OfflineInterpreter interpreter = simulationControl.getInterpreter();
        StateMachine.State interpreterState = interpreter.getStateMachine().getCurrentState();
        if (interpreterState == interpreterState.getState(OfflineInterpreter.CycleStepping.class) || interpreterState == interpreterState.getState(OfflineInterpreter.TimerStepping.class)) {
            interpreter.getStateMachine().addInput("suspend");
        } else if (simulationControl.getSelectedStepUnit() instanceof SimulationControl.Cycles) {
            simulationControl.setStepProgressContent(String.valueOf(simulationControl.getCycleField().getValue()));
            interpreter.setCyclesToRun(simulationControl.getCycleField().getValue());
            interpreter.getStateMachine().addInput("cycleStep");
        } else {
            TimeUnit selectedTimeUnit = (TimeUnit)simulationControl.getSelectedStepUnit();
            TimeUnit time = TimeUnit.getNewTimeObject(selectedTimeUnit.getUnitKey());
            String timeString = simulationControl.getTimeField().getText();
            int high = Integer.parseInt(timeString.substring(0, timeString.indexOf(58)));
            int low = Integer.parseInt(timeString.substring(timeString.indexOf(58) + 1).trim());
            time.setTime(high, low);
            Timer timer = new Timer();
            timer.init(interpreter);
            timer.setParamTime(time);
            interpreter.setStepTimer(timer);
            interpreter.getStateMachine().addInput("timerStep");
        }
        return true;
    }
}

